###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for httpd RHSA-2008:0967-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870016);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0967-01");
  script_cve_id("CVE-2008-2364", "CVE-2008-2939");
  script_name(english: "RedHat Update for httpd RHSA-2008:0967-01");
  desc["english"] = "

  Vulnerability Insight:
  The Apache HTTP Server is a popular Web server.
  
  A flaw was found in the mod_proxy Apache module. An attacker in control of
  a Web server to which requests were being proxied could have caused a
  limited denial of service due to CPU consumption and stack exhaustion.
  (CVE-2008-2364)
  
  A flaw was found in the mod_proxy_ftp Apache module. If Apache was
  configured to support FTP-over-HTTP proxying, a remote attacker could have
  performed a cross-site scripting attack. (CVE-2008-2939)
  
  In addition, these updated packages fix a bug found in the handling of the
  &quot;ProxyRemoteMatch&quot; directive in the Red Hat Enterprise Linux 4 httpd
  packages. This bug is not present in the Red Hat Enterprise Linux 3 or Red
  Hat Enterprise Linux 5 packages.
  
  Users of httpd should upgrade to these updated packages, which contain
  backported patches to correct these issues.


  Affected Software/OS:
  httpd on Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-November/msg00003.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of httpd");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.2.3~11.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-debuginfo", rpm:"httpd-debuginfo~2.2.3~11.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-devel", rpm:"httpd-devel~2.2.3~11.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-manual", rpm:"httpd-manual~2.2.3~11.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.2.3~11.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.0.52~41.ent.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-debuginfo", rpm:"httpd-debuginfo~2.0.52~41.ent.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-devel", rpm:"httpd-devel~2.0.52~41.ent.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-manual", rpm:"httpd-manual~2.0.52~41.ent.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-suexec", rpm:"httpd-suexec~2.0.52~41.ent.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.0.52~41.ent.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.0.46~71.ent", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-debuginfo", rpm:"httpd-debuginfo~2.0.46~71.ent", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-devel", rpm:"httpd-devel~2.0.46~71.ent", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.0.46~71.ent", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}