###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for pam_krb5 RHSA-2008:0907-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870121);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0907-01");
  script_cve_id("CVE-2008-3825");
  script_name(english: "RedHat Update for pam_krb5 RHSA-2008:0907-01");
  desc["english"] = "

  Vulnerability Insight:
  The pam_krb5 module allows Pluggable Authentication Modules (PAM) aware
  applications to use Kerberos to verify user identities by obtaining user
  credentials at log in time.
  
  A flaw was found in the pam_krb5 &quot;existing_ticket&quot; configuration option. If
  a system is configured to use an existing credential cache via the
  &quot;existing_ticket&quot; option, it may be possible for a local user to gain
  elevated privileges by using a different, local user's credential cache.
  (CVE-2008-3825)
  
  Red Hat would like to thank Stéphane Bertin for responsibly disclosing this
  issue.
  
  Users of pam_krb5 should upgrade to this updated package, which contains a
  backported patch to resolve this issue.


  Affected Software/OS:
  pam_krb5 on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-October/msg00005.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pam_krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"pam_krb5", rpm:"pam_krb5~2.2.14~1.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pam_krb5-debuginfo", rpm:"pam_krb5-debuginfo~2.2.14~1.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}