###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for poppler RHSA-2008:0239-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870056);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0239-01");
  script_cve_id("CVE-2008-1693");
  script_name(english: "RedHat Update for poppler RHSA-2008:0239-01");
  desc["english"] = "

  Vulnerability Insight:
  Poppler is a PDF rendering library, used by applications such as Evince.
  
  Kees Cook discovered a flaw in the way poppler displayed malformed fonts
  embedded in PDF files. An attacker could create a malicious PDF file that
  would cause applications that use poppler -- such as Evince -- to crash,
  or, potentially, execute arbitrary code when opened. (CVE-2008-1693)
  
  Users are advised to upgrade to these updated packages, which contain
  backported patches to resolve this issue.


  Affected Software/OS:
  poppler on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-April/msg00021.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of poppler");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.5.4~4.4.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-debuginfo", rpm:"poppler-debuginfo~0.5.4~4.4.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.5.4~4.4.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-utils", rpm:"poppler-utils~0.5.4~4.4.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}