###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2007:0993-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870182);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2007:0993-01");
  script_cve_id("CVE-2007-4571", "CVE-2007-4997", "CVE-2007-5494");
  script_name(english: "RedHat Update for kernel RHSA-2007:0993-01");
  desc["english"] = "

  Vulnerability Insight:
  The Linux kernel handles the basic functions of the operating system.
  
  These new kernel packages contain fixes for the following security issues:
  
  A memory leak was found in the Red Hat Content Accelerator kernel patch.  A
  local user could use this flaw to cause a denial of service (memory
  exhaustion). (CVE-2007-5494, Important)
  
  A flaw was found in the handling of IEEE 802.11 frames affecting several
  wireless LAN modules.  In certain circumstances, a remote attacker could
  trigger this flaw by sending a malicious packet over a wireless network and
  cause a denial of service (kernel crash). (CVE-2007-4997, Important). 
  
  A flaw was found in the Advanced Linux Sound Architecture (ALSA). A local
  user who had the ability to read the /proc/driver/snd-page-alloc file could
  see portions of kernel memory. (CVE-2007-4571, Moderate). 
  
  In addition to the security issues described above, several bug fixes
  preventing possible memory corruption, system crashes, SCSI I/O fails,
  networking drivers performance regression and journaling block device layer
  issue were also included.
  
  Red Hat Enterprise Linux 5 users are advised to upgrade to these packages,
  which contain backported patches to resolve these issues.
  
  Red Hat would like to credit Vasily Averin, Chris Evans, and Neil Kettle 
  for reporting the security issues corrected by this update.


  Affected Software/OS:
  kernel on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2007-November/msg00001.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-debuginfo", rpm:"kernel-xen-debuginfo~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-devel", rpm:"kernel-xen-devel~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.18~53.1.4.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}