###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for compat-openldap CESA-2008:0110 centos5 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880087);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0110");
  script_cve_id("CVE-2007-6698", "CVE-2008-0658");
  script_name(english: "CentOS Update for compat-openldap CESA-2008:0110 centos5 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  OpenLDAP is an open source suite of Lightweight Directory Access Protocol
  (LDAP) applications and development tools. LDAP is a set of protocols for
  accessing directory services.
  
  These updated openldap packages fix a flaw in the way the OpenLDAP slapd
  daemon handled modify and modrdn requests with NOOP control on objects
  stored in a Berkeley DB (BDB) storage backend.  An authenticated attacker
  with permission to perform modify or modrdn operations on such LDAP objects
  could cause slapd to crash. (CVE-2007-6698, CVE-2008-0658)
  
  Users of openldap should upgrade to these updated packages, which contain a
  backported patch to correct this issue.


  Affected Software/OS:
  compat-openldap on CentOS 5

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-February/014703.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of compat-openldap");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS5")
{

  if(isrpmvuln(pkg:"compat-openldap", rpm:"compat-openldap~2.3.27_2.2.29~8.el5_1.3", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap", rpm:"openldap~2.3.27~8.el5_1.3", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-clients", rpm:"openldap-clients~2.3.27~8.el5_1.3", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-devel", rpm:"openldap-devel~2.3.27~8.el5_1.3", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers", rpm:"openldap-servers~2.3.27~8.el5_1.3", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers-sql", rpm:"openldap-servers-sql~2.3.27~8.el5_1.3", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}