#
#VID 184f5d0b-0fe8-11d9-8a8a-000c41e2cdad
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52373);
 script_bugtraq_id(11243);
 script_cve_id("CVE-2004-0749");
 script_version ("$");
 name["english"] = "FreeBSD Ports: subversion, subversion-perl, subversion-python";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   subversion
   subversion-perl
   subversion-python

CVE-2004-0749
The mod_authz_svn module in Subversion 1.0.7 and earlier does not
properly restrict access to all metadata on unreadable paths, which
could allow remote attackers to gain sensitive information via (1) svn
log -v, (2) svn propget, or (3) svn blame, and other commands that
follow renames.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://subversion.tigris.org/security/CVE-2004-0749-advisory.txt
http://www.vuxml.org/freebsd/184f5d0b-0fe8-11d9-8a8a-000c41e2cdad.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: subversion, subversion-perl, subversion-python";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"subversion");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.8")<0) {
    security_note(0, data:"Package subversion version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"subversion-perl");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.8")<0) {
    security_note(0, data:"Package subversion-perl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"subversion-python");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.8")<0) {
    security_note(0, data:"Package subversion-python version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
