#
#VID ea2411a4-08e8-11de-b88a-0022157515b2
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID ea2411a4-08e8-11de-b88a-0022157515b2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63514);
 script_cve_id("CVE-2009-0040");
 script_bugtraq_id(33827);
 script_version ("$");
 name["english"] = "FreeBSD Ports: pngcrush";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: pngcrush

CVE-2009-0040
The PNG reference library (aka libpng) before 1.0.43, and 1.2.x before
1.2.35, as used in pngcrush and other applications, allows
context-dependent attackers to cause a denial of service (application
crash) or possibly execute arbitrary code via a crafted PNG file that
triggers a free of an uninitialized pointer in (1) the png_read_png
function, (2) pCAL chunk handling, or (3) setup of 16-bit gamma
tables.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/33976
http://xforce.iss.net/xforce/xfdb/48819
http://www.vuxml.org/freebsd/ea2411a4-08e8-11de-b88a-0022157515b2.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: pngcrush";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"pngcrush");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.14")<0) {
    security_note(0, data:"Package pngcrush version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
