#
#VID 0c4d5973-f2ab-11d8-9837-000c41e2cdad
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52419);
 script_cve_id("CVE-2004-0457");
 script_version ("$");
 name["english"] = "FreeBSD Ports: mysql-scripts";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mysql-scripts

CVE-2004-0457
The mysqlhotcopy script in mysql 4.0.20 and earlier, when using the
scp method from the mysql-server package, allows local users to
overwrite arbitrary files via a symlink attack on temporary files.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.debian.org/security/2004/dsa-540
http://lists.mysql.com/internals/15185
http://www.vuxml.org/freebsd/0c4d5973-f2ab-11d8-9837-000c41e2cdad.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: mysql-scripts";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mysql-scripts");
if(!isnull(bver) && revcomp(a:bver, b:"3.23.58")<=0) {
    security_note(0, data:"Package mysql-scripts version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"4")>0 && revcomp(a:bver, b:"4.0.20")<=0) {
    security_note(0, data:"Package mysql-scripts version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"4.1")>0 && revcomp(a:bver, b:"4.1.3")<=0) {
    security_note(0, data:"Package mysql-scripts version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"5")>0 && revcomp(a:bver, b:"5.0.0_1")<=0) {
    security_note(0, data:"Package mysql-scripts version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
