#
#VID ce109fd4-67f3-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52233);
 script_bugtraq_id(12277);
 script_cve_id("CVE-2005-0004");
 script_version ("$");
 name["english"] = "FreeBSD Ports: mysql-scripts";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mysql-scripts

CVE-2005-0004
The mysqlaccess script in MySQL 4.0.23 and earlier, 4.1.x before
4.1.10, 5.0.x before 5.0.3, and other versions including 3.x, allows
local users to overwrite arbitrary files or read temporary files via a
symlink attack on temporary files.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://lists.mysql.com/internals/20600
http://www.vuxml.org/freebsd/ce109fd4-67f3-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: mysql-scripts";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mysql-scripts");
if(!isnull(bver) && revcomp(a:bver, b:"3.23.58_2")<0) {
    security_note(0, data:"Package mysql-scripts version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"4")>0 && revcomp(a:bver, b:"4.0.23a_1")<0) {
    security_note(0, data:"Package mysql-scripts version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"4.1")>0 && revcomp(a:bver, b:"4.1.9_1")<0) {
    security_note(0, data:"Package mysql-scripts version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"5")>0 && revcomp(a:bver, b:"5.0.2_1")<0) {
    security_note(0, data:"Package mysql-scripts version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
