#
#VID 78f456fd-9c87-11dd-a55e-00163e000016
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 78f456fd-9c87-11dd-a55e-00163e000016
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61802);
 script_cve_id("CVE-2007-6243", "CVE-2008-3873", "CVE-2007-4324", "CVE-2008-4401", "CVE-2008-4503");
 script_version ("$");
 name["english"] = "FreeBSD Ports: linux-flashplugin";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: linux-flashplugin

CVE-2007-6243
Adobe Flash Player 9.x up to 9.0.48.0, 8.x up to 8.0.35.0, and 7.x up
to 7.0.70.0 does not sufficiently restrict the interpretation and
usage of cross-domain policy files, which makes it easier for remote
attackers to conduct cross-domain and cross-site scripting (XSS)
attacks.

CVE-2008-3873
The System.setClipboard method in ActionScript in Adobe Flash Player
9.0.124.0 and earlier allows remote attackers to populate the
clipboard with a URL that is difficult to delete and does not require
user interaction to populate the clipboard, as exploited in the wild
in August 2008.

CVE-2007-4324
ActionScript 3 (AS3) in Adobe Flash Player 9.0.47.0, and other
versions and other 9.0.124.0 and earlier versions, allows remote
attackers to bypass the Security Sandbox Model, obtain sensitive
information, and port scan arbitrary hosts via a Flash (SWF) movie
that specifies a connection to make, then uses timing discrepancies
from the SecurityErrorEvent error to determine whether a port is open
or not.  NOTE: 9.0.115.0 introduces support for a workaround, but does
not fix the vulnerability.

CVE-2008-4401
ActionScript in Adobe Flash Player 9.0.124.0 and earlier does not
require user interaction in conjunction with (1) the
FileReference.browse operation in the FileReference upload API or (2)
the FileReference.download operation in the FileReference download
API, which allows remote attackers to create a browse dialog box, and
possibly have unspecified other impact, via an SWF file.

CVE-2008-4503
The Settings Manager in Adobe Flash Player 9.0.124.0 and earlier
allows remote attackers to cause victims to unknowingly click on a
link or dialog via access control dialogs disguised as normal
graphical elements, as demonstrated by hijacking the camera or
microphone, and related to 'clickjacking.'

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.adobe.com/support/security/bulletins/apsb08-18.html
http://www.vuxml.org/freebsd/78f456fd-9c87-11dd-a55e-00163e000016.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: linux-flashplugin";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"linux-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"9.0r124_1")<=0) {
    security_note(0, data:"Package linux-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
