# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5284 (quagga)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64030);
 script_cve_id("CVE-2009-1572");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-5284 (quagga)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to quagga
announced via advisory FEDORA-2009-5284.

Update Information:

The latest upstream version fixes serious assert crashing with ASN4's.
ChangeLog:

* Wed May 20 2009 Jiri Skala  - 0.99.12-1
- update to latest upstream version
- fix #499960 - BGPd in Quagga prior to 0.99.12 has a serious assert problem crashing with ASN4's
* Mon May  4 2009 Jiri Skala  - 0.99.10-3
- fixes #498832 -  bgpd crashes on as paths containing more 6 digit as numbers

References:

[ 1 ] Bug #499033 - CVE-2009-1572 quagga: crash in bgpd when receiving updates containing asn32
https://bugzilla.redhat.com/show_bug.cgi?id=499033

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update quagga' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5284

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-5284 (quagga)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"quagga", rpm:"quagga~0.99.12~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"quagga-contrib", rpm:"quagga-contrib~0.99.12~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"quagga-devel", rpm:"quagga-devel~0.99.12~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"quagga-debuginfo", rpm:"quagga-debuginfo~0.99.12~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
