# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3410 (bugzilla)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63774);
 script_cve_id("CVE-2009-1213");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-3410 (bugzilla)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to bugzilla
announced via advisory FEDORA-2009-3410.

ChangeLog:

* Mon Apr  6 2009 Itamar Reis Peixoto  3.2.3-1
- fix CVE-2009-1213
* Thu Mar  5 2009 Itamar Reis Peixoto  3.2.2-2
- fix from BZ #474250 Comment #16, from Chris Eveleigh -->
- add python BR for contrib subpackage
- fix description
- change Requires perl-SOAP-Lite to perl(SOAP::Lite) according guidelines
* Sun Mar  1 2009 Itamar Reis Peixoto  3.2.2-1
- thanks to Chris Eveleigh 
- for contributing with patches :-)
- Upgrade to upstream 3.2.2 to fix multiple security vulns
- Removed old perl_requires exclusions, added new ones for RADIUS, Oracle and sanitycheck.cgi
- Added Oracle to supported DBs in description (and moved line breaks)
- Include a patch to fix max_allowed_packet warnin when using with mysql

References:

[ 1 ] Bug #494398 - CVE-2009-1213 bugzilla: CSRF vulnerability in attachment editing
https://bugzilla.redhat.com/show_bug.cgi?id=494398

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update bugzilla' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3410

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-3410 (bugzilla)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bugzilla", rpm:"bugzilla~3.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-contrib", rpm:"bugzilla-contrib~3.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-doc", rpm:"bugzilla-doc~3.2.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
