# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 842-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55518);
 script_bugtraq_id(14560);
 script_cve_id("CVE-2005-2498");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 842-1 (egroupware)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to egroupware
announced via advisory DSA 842-1.

Stefan Esser discovered a vulnerability in the XML-RPC libraries which
are also present in egroupware, a web-based groupware suite, that
allows injection of arbitrary PHP code into eval() statements.

The old stable distribution (woody) does not contain egroupware packages.

For the stable distribution (sarge) this problem has been fixed in
version 1.0.0.007-2.dfsg-2sarge2.

For the unstable distribution (sid) this problem has been fixed in
version 1.0.0.009.dfsg-1.

We recommend that you upgrade your egroupware packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20842-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 842-1 (egroupware)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"egroupware-addressbook", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-bookmarks", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-calendar", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-comic", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-core", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-developer-tools", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-email", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-emailadmin", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-etemplate", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-felamimail", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-filemanager", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-forum", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-ftp", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-fudforum", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-headlines", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-infolog", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-jinn", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-ldap", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-manual", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-messenger", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-news-admin", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-phpbrain", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-phpldapadmin", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-phpsysinfo", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-polls", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-projects", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-registration", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-sitemgr", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-stocks", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-tts", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-wiki", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware", ver:"1.0.0.007-2.dfsg-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
