# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 767-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54443);
 script_bugtraq_id(14345);
 script_cve_id("CVE-2005-1852");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 767-1 (ekg)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ekg
announced via advisory DSA 767-1.

Marcin Slusarz discovered two integer overflow vulnerabilities in
libgadu, a library provided and used by ekg, a console Gadu Gadu
client, an instant messaging program, that could lead to the execution
of arbitrary code.

The library is also used by other packages such as kopete, which
should be restarted to take effect of this update.

The old stable distribution (woody) does not contain an ekg package.

For the stable distribution (sarge) these problems have been fixed in
version 1.5+20050411-5.

For the unstable distribution (sid) these problems have been fixed in
version 1.5+20050718+1.6rc3-1.

We recommend that you upgrade your ekg package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20767-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 767-1 (ekg)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ekg", ver:"1.5+20050411-5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgadu-dev", ver:"1.5+20050411-5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgadu3", ver:"1.5+20050411-5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
