# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 763-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54412);
 script_bugtraq_id(14340);
 script_cve_id("CVE-2005-1849");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 763-1 (zlib)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to zlib
announced via advisory DSA 763-1.

Markus Oberhumer discovered a flaw in the way zlib, a library used for
file compression and decompression, handles invalid input. This flaw can
cause programs which use zlib to crash when opening an invalid file.

This problem does not affect the old stable distribution (woody).

For the current stable distribution (sarge), this problem has been fixed
in version 1.2.2-4.sarge.2.

For the unstable distribution (sid), this problem has been fixed in
version 1.2.3-1.

We recommend that you upgrade your zlib package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20763-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 763-1 (zlib)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zlib1g-dev", ver:"1.2.2-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zlib1g", ver:"1.2.2-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zlib-bin", ver:"1.2.2-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib64z1", ver:"1.2.2-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib64z1-dev", ver:"1.2.2-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
