# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 683-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53511);
 script_cve_id("CVE-2005-0245", "CVE-2005-0247");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 683-1 (postgresql)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to postgresql
announced via advisory DSA 683-1.

Several buffer overflows have been discovered in PL/PgSQL as part of
the PostgreSQL engine which could lead to the execution of arbitrary
code.

For the stable distribution (woody) these problems have been fixed in
version 7.2.1-2woody8.

For the unstable distribution (sid) these problems have been fixed in
version 7.4.7-2.

We recommend that you upgrade your postgresql packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20683-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 683-1 (postgresql)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg3", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgperl", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgsql2", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtcl", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"odbc-postgresql", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pgaccess", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-dev", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-pygresql", ver:"7.2.1-2woody8", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
