# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 576-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53268);
 script_cve_id("CVE-1999-0710", "CVE-2004-0918");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 576-1 (squid)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squid
announced via advisory DSA 576-1.

Several security vulnerabilities have been discovered in Squid, the
internet object cache, the popular WWW proxy cache.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-1999-0710

It is possible to bypass access lists and scan arbitrary hosts and
ports in the network through cachemgr.cgi, which is installed by
default.  This update disables this feature and introduces a
configuration file (/etc/squid/cachemgr.conf) to control
this behavier.

CVE-2004-0918

The asn_parse_header function (asn1.c) in the SNMP module for
Squid allows remote attackers to cause a denial of service via
certain SNMP packets with negative length fields that causes a
memory allocation error.

For the stable distribution (woody) these problems have been fixed in
version 2.4.6-2woody4.

For the unstable distribution (sid) these problems have been fixed in
version 2.5.7-1.

We recommend that you upgrade your squid package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20576-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 576-1 (squid)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squid", ver:"2.4.6-2woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.4.6-2woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"2.4.6-2woody4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
