# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 389-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53673);
 script_cve_id("CVE-2003-0785");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 389-1 (ipmasq)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ipmasq
announced via advisory DSA 389-1.

ipmasq is a package which simplifies configuration of Linux IP
masquerading, a form of network address translation which allows a
number of hosts to share a single public IP address.  Due to use of
certain improper filtering rules, traffic arriving on the external
interface addressed for an internal host would be forwarded,
regardless of whether it was associated with an established
connection.  This vulnerability could be exploited by an attacker
capable of forwarding IP traffic with an arbitrary destination address
to the external interface of a system with ipmasq installed.

For the current stable distribution (woody) this problem has been
fixed in version 3.5.10c.

For the unstable distribution (sid) this problem has been fixed in
version 3.5.12.

We recommend that you update your ipmasq package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20389-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 389-1 (ipmasq)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ipmasq", ver:"3.5.10c", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
