# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 382-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53698);
 script_cve_id("CVE-2003-0693", "CVE-2003-0695");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 382-2 (ssh)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ssh
announced via advisory DSA 382-2.

This advisory is an addition to the earlier DSA-382-1 advisory: two more
buffer handling problems have been found in addition to the one
described in DSA-382-1. It is not known if these bugs are exploitable,
but as a precaution an upgrade is advised.

For the Debian stable distribution these bugs have been fixed in version
1:3.4p1-1.woody.2 .

Please note that if a machine is setup to install packages from
proposed-updates it will not automatically install this update.




Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20382-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 382-2 (ssh)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"3.4p1-1.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh", ver:"3.4p1-1.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
