# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 292-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53364);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 292-2 (mime-support)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mime-support
announced via advisory DSA 292-2.

Unfortunately yesterday's update for mime-support did not exactly work
as expected, which requires an update.  For completeness we include
the advisory text:

Colin Phipps discovered several problems in mime-support, that contains
support programs for the MIME control files 'mime.types' and 'mailcap'.
When a temporary file is to be used it is created insecurely, allowing
an attacker to overwrite arbitrary under the user id of the person
executing run-mailcap, most probably root.  Additionally the program did
not properly escape shell escape characters when executing a command.
This is unlikely to be exploitable, though.

For the stable distribution (woody) these problems have been fixed in
version 3.18-1.2.

For the old stable distribution (potato) these problems have been
fixed in version 3.9-1.2.

For the unstable distribution (sid) these problems have been
fixed in version 3.22-1 (same as DSA 292-1).

We recommend that you upgrade your mime-support packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20292-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 292-2 (mime-support)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mime-support", ver:"3.9-1.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mime-support", ver:"3.18-1.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
