# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 220-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53719);
 script_cve_id("CVE-2002-1341");
 script_bugtraq_id(6302);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 220-1 (squirrelmail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squirrelmail
announced via advisory DSA 220-1.

A cross site scripting vulnerability has been discovered in
squirrelmail, a feature-rich webmail package written in PHP4.
Squirrelmail doesn't sanitize user provided variables in all places,
leaving it vulnerable to a cross site scripting attack.

For the current stable distribution (woody) this problem has been
fixed in version 1.2.6-1.3.  The old stable distribution (potato) is
not affected since it doesn't contain a squirrelmail package.

An updated package for the current unstable distribution (sid) is
expected soon.

We recommend that you upgrade your squirrelmail package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20220-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 220-1 (squirrelmail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.2.6-1.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
