# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 219-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53741);
 script_cve_id("CVE-2002-1403");
 script_bugtraq_id(6200);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 219-1 (dhcpcd)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to dhcpcd
announced via advisory DSA 219-1.

Simon Kelly discovered a vulnerability in dhcpcd, an RFC2131 and
RFC1541 compliant DHCP client daemon, that runs with root privileges
on client machines.  A malicious administrator of the regular or an
untrusted DHCP server may execute any command with root privileges on
the DHCP client machine by sending the command enclosed in shell
metacharacters in one of the options provided by the DHCP server.

This problem has been fixed in version 1.3.17pl2-8.1 for the old
stable distribution (potato) and in version 1.3.22pl2-2 for the
testing (sarge) and unstable (sid) distributions.  The current stable
distribution (woody) does not contain a dhcpcd package.

We recommend that you upgrade your dhcpcd package (on the client


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20219-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 219-1 (dhcpcd)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"dhcpcd", ver:"1.3.17pl2-8.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
