# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 187-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53735);
 script_cve_id("CVE-2002-0839", "CVE-2002-0840", "CVE-2002-0843", "CVE-2001-0131", "CVE-2002-1233");
 script_bugtraq_id(5847,5884,5887);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 187-1 (apache)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to apache
announced via advisory DSA 187-1.

According to David Wagner, iDEFENSE and the Apache HTTP Server
Project, several remotely exploitable vulnerabilities have been found
in the Apache package, a commonly used webserver.  These
vulnerabilities could allow an attacker to enact a denial of service
against a server or execute a cross scripting attack.  The Common
Vulnerabilities and Exposures (CVE) project identified the following
vulnerabilities:

1. CVE-2002-0839: A vulnerability exists on platforms using System V
shared memory based scoreboards.  This vulnerability allows an
attacker who can execute under the Apache UID to exploit the Apache
shared memory scoreboard format and send a signal to any process as
root or cause a local denial of service attack.

2. CVE-2002-0840: Apache is susceptible to a cross site scripting
vulnerability in the default 404 page of any web server hosted on a
domain that allows wildcard DNS lookups.

3. CVE-2002-0843: There were some possible overflows in the utility
ApacheBench (ab) which could be exploited by a malicious server.

4. CVE-2002-1233: A race condition in the htpasswd and htdigest
program enables a malicious local user to read or even modify the
contents of a password file or easily create and overwrite files as
the user running the htpasswd (or htdigest respectively) program.

5. CVE-2001-0131: htpasswd and htdigest in Apache 2.0a9, 1.3.14, and
others allows local users to overwrite arbitrary files via a
symlink attack.

This is the same vulnerability as CVE-2002-1233, which was fixed in
potato already but got lost later and was never applied upstream.

5. NO-CAN: Several buffer overflows have been found in the ApacheBench
(ab) utility that could be exploited by a remote server returning
very long strings.

These problems have been fixed in version 1.3.26-0woody3 for the
current stable distribution (woody) and in 1.3.9-14.3 for the old
stable distribution (potato).  Corrected packages for the unstable
distribution (sid) are expected soon.

We recommend that you upgrade your Apache package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20187-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 187-1 (apache)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache-doc", ver:"1.3.9-14.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache", ver:"1.3.9-14.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-common", ver:"1.3.9-14.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-dev", ver:"1.3.9-14.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-doc", ver:"1.3.26-0woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache", ver:"1.3.26-0woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-common", ver:"1.3.26-0woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-dev", ver:"1.3.26-0woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
