# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1764-1 (tunapie)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63791);
 script_cve_id("CVE-2009-1253", "CVE-2009-1254");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1764-1 (tunapie)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to tunapie
announced via advisory DSA 1764-1.

Several vulnerabilities have been discovered in Tunapie, a GUI frontend
to video and radio streams. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-1253

Kees Cook discovered that insecure handling of temporary files may
lead to local denial of service through symlink attacks.

CVE-2009-1254

Mike Coleman discovered that insufficient escaping of stream
URLs may lead to the execution of arbitrary commands if a user
is tricked into opening a malformed stream URL.

For the old stable distribution (etch), these problems have been fixed
in version 1.3.1-1+etch2. Due to a technical problem, this update cannot
be released synchronously with the stable (lenny) version, but will
appear soon.

For the stable distribution (lenny), these problems have been fixed in
version 2.1.8-2.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your tunapie package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201764-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1764-1 (tunapie)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tunapie", ver:"2.1.8-2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
