# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1511-1 (libicu)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60496);
 script_cve_id("CVE-2007-4770", "CVE-2007-4771");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1511-1 (libicu)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libicu
announced via advisory DSA 1511-1.

Several local vulnerabilities have been discovered in libicu,
International Components for Unicode, The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2007-4770
libicu in International Components for Unicode (ICU) 3.8.1 and earlier
attempts to process backreferences to the nonexistent capture group
zero (aka \0), which might allow context-dependent attackers to read
from, or write to, out-of-bounds memory locations, related to
corruption of REStackFrames.

CVE-2007-4771
Heap-based buffer overflow in the doInterval function in regexcmp.cpp
in libicu in International Components for Unicode (ICU) 3.8.1 and
earlier allows context-dependent attackers to cause a denial of
service (memory consumption) and possibly have unspecified other
impact via a regular expression that writes a large amount of data to
the backtracking stack.

For the stable distribution (etch), these problems have been fixed in
version 3.6-2etch1.

For the unstable distribution (sid), these problems have been fixed in
version 3.8-6.

We recommend that you upgrade your libicu package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201511-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1511-1 (libicu)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"icu-doc", ver:"3.6-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu36-dev", ver:"3.6-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu36", ver:"3.6-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
