# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1481-1 (python-cherrypy)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60291);
 script_cve_id("CVE-2008-0252");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1481-1 (python-cherrypy)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to python-cherrypy
announced via advisory DSA 1481-1.

It was discovered that a directory traversal vulnerability in CherryPy,
a pythonic, object-oriented web development framework may lead to denial
of service by deleting files through malicious session IDs in cookies.

For the stable distribution (etch), this problem has been fixed in
version 2.2.1-3etch1.

The old stable distribution (sarge) doesn't contain python-cherrypy.

We recommend that you upgrade your python-cherrypy packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201481-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1481-1 (python-cherrypy)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-cherrypy", ver:"2.2.1-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
