# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1314-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58362);
 script_cve_id("CVE-2007-3099", "CVE-2007-3100");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1314-1 (open-iscsi)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to open-iscsi
announced via advisory DSA 1314-1.

Several local and remote vulnerabilities have been discovered in
open-iscsi, a transport-independent iSCSI implementation. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-3099

Olaf Kirch discovered that due to a programming error access to the
management interface socket was insufficiently protected, which allows
denial of service.

CVE-2007-3100

Olaf Kirch discovered that access to a semaphore used in the logging
code was insufficiently protected, allowing denial of service.

The oldstable distribution (sarge) doesn't include open-iscsi.

For the stable distribution (etch) these problems have been fixed
in version 2.0.730-1etch1.

For the unstable distribution (sid) these problems have been fixed in
version 2.0.865-1.

We recommend that you upgrade your open-iscsi packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201314-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1314-1 (open-iscsi)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"open-iscsi", ver:"2.0.730-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
