# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1151-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57295);
 script_cve_id("CVE-2006-3121");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1151-1 (heartbeat)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to heartbeat
announced via advisory DSA 1151-1.

Yan Rong Ge discovered out-of-boundary memory access in heartbeat, the
subsystem for High-Availability Linux.  This could be used by a remote
attacker to cause a denial of service.

For the stable distribution (sarge) this problem has been fixed in
version 1.2.3-9sarge6.

For the unstable distribution (sid) this problem has been fixed in
version 1.2.4-14 and heartbeat-2 2.0.6-2.

We recommend that you upgrade your heartbeat packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201151-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1151-1 (heartbeat)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ldirectord", ver:"1.2.3-9sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heartbeat", ver:"1.2.3-9sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heartbeat-dev", ver:"1.2.3-9sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpils-dev", ver:"1.2.3-9sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpils0", ver:"1.2.3-9sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstonith-dev", ver:"1.2.3-9sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libstonith0", ver:"1.2.3-9sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"stonith", ver:"1.2.3-9sarge6", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
