# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 044-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53805);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 044-1 (mailx)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mailx
announced via advisory DSA 044-1.

The mail program (a simple tool to read and send email) as
distributed with Debian GNU/Linux 2.2 has a buffer overflow in the
input parsing code. Since mail is installed setgid mail by default
this allowed local users to use it to gain access to mail group.

Since the mail code was never written to be secure fixing it
properly would mean a large rewrite. Instead of doing this we
decided to no longer install it setgid. This means that it can no
longer lock your mailbox properly on systems for which you need
group mail to write to the mailspool, but it will still work for
sending email.

This has been fixed in mailx version 8.1.1-10.1.5. If you have
suidmanager installed you can also make this manually with the
following command:

suidregister /usr/bin/mail root root 0755

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20044-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 044-1 (mailx)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mailx", ver:"8.1.1-10.1.5", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
