# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0479 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63974);
 script_cve_id("CVE-2009-0663", "CVE-2009-1341");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0479";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0479.

Perl DBI is a database access Application Programming Interface (API) for
the Perl language. perl-DBD-Pg allows Perl applications to access
PostgreSQL database servers.

A heap-based buffer overflow flaw was discovered in the pg_getline function
implementation. If the pg_getline or getline functions read large,
untrusted records from a database, it could cause an application using
these functions to crash or, possibly, execute arbitrary code.
(CVE-2009-0663)

Note: After installing this update, pg_getline may return more data than
specified by its second argument, as this argument will be ignored. This is
consistent with current upstream behavior. Previously, the length limit
(the second argument) was not enforced, allowing a buffer overflow.

A memory leak flaw was found in the function performing the de-quoting of
BYTEA type values acquired from a database. An attacker able to cause an
application using perl-DBD-Pg to perform a large number of SQL queries
returning BYTEA records, could cause the application to use excessive
amounts of memory or, possibly, crash. (CVE-2009-1341)

All users of perl-DBD-Pg are advised to upgrade to this updated package,
which contains backported patches to fix these issues. Applications using
perl-DBD-Pg must be restarted for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0479.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0479";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-DBD-Pg", rpm:"perl-DBD-Pg~1.49~2.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-DBD-Pg-debuginfo", rpm:"perl-DBD-Pg-debuginfo~1.49~2.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
