# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0336 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63637);
 script_cve_id("CVE-2008-4316");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0336";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0336.

GLib is the low-level core library that forms the basis for projects such
as GTK+ and GNOME. It provides data structure handling for C, portability
wrappers, and interfaces for such runtime functionality as an event loop,
threads, dynamic loading, and an object system.

Diego Pettenò discovered multiple integer overflows causing heap-based
buffer overflows in GLib's Base64 encoding and decoding functions. An
attacker could use these flaws to crash an application using GLib's Base64
functions to encode or decode large, untrusted inputs, or, possibly,
execute arbitrary code as the user running the application. (CVE-2008-4316)

Note: No application shipped with Red Hat Enterprise Linux 5 uses the
affected functions. Third-party applications may, however, be affected.

All users of glib2 should upgrade to these updated packages, which contain
backported patches to resolve these issues.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0336.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0336";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.12.3~4.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-debuginfo", rpm:"glib2-debuginfo~2.12.3~4.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.12.3~4.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
