# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0297 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63473);
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0297";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0297.

In accordance with the Red Hat Enterprise Linux Errata Support Policy, the
7 years life-cycle of Red Hat Enterprise Linux 2.1 will end on May 31 2009.

﻿After that date, Red Hat will discontinue the technical support services,
bugfix, enhancement and security errata updates for the following products:

* Red Hat Enterprise Linux AS 2.1
* Red Hat Enterprise Linux ES 2.1
* Red Hat Enterprise Linux WS 2.1
* Red Hat Linux Advanced Server 2.1
* Red Hat Linux Advanced Workstation 2.1

Customers running production workloads on Enterprise Linux 2.1 should plan
to migrate to a later version before May 31, 2009.  One benefit of a Red
Hat subscription is the right to upgrade to never versions of Enterprise
Linux for no extra cost. As an Enterprise Linux subscriber, you have the
option of migrating to the following supported versions:

* version 3 (Generally Available: Oct 2003, End-Of-Life: Oct 2010)
* version 4 (GA: Feb 2005, EOL: Feb 2012)
* version 5 (GA: Mar 2007, EOL: Mar 2014)

These supported versions of Enterprise Linux are available for download
from Red Hat Network.

For those customers who cannot migrate from Enterprise Linux 2.1 before its
end-of-life date, Red Hat will offer limited extended support contracts.
For more information, contact your Red Hat sales representative.

Details of the Red Hat Enterprise Linux life-cycle can be found on the Red
Hat website: http://www.redhat.com/security/updates/errata/

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0297.html
http://www.redhat.com/security/updates/errata/

Risk factor : Low";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0297";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"redhat-release-as", rpm:"redhat-release-as~2.1AS~24", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"redhat-release-as", rpm:"redhat-release-as~2.1AS~124", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"redhat-release-aw", rpm:"redhat-release-aw~2.1AW~24", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"redhat-release-es", rpm:"redhat-release-es~2.1ES~24", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"redhat-release-ws", rpm:"redhat-release-ws~2.1WS~24", rls:"RHENT_2.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
