# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0295 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63642);
 script_cve_id("CVE-2008-6123");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0295";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0295.

The Simple Network Management Protocol (SNMP) is a protocol used for
network management.

It was discovered that the snmpd daemon did not use TCP wrappers correctly,
causing network hosts access restrictions defined in /etc/hosts.allow and
/etc/hosts.deny to not be honored. A remote attacker could use this flaw
to bypass intended access restrictions. (CVE-2008-6123)

This issue only affected configurations where hosts.allow and hosts.deny
were used to limit access to the SNMP server. To obtain information from
the server, the attacker would have to successfully authenticate, usually
by providing a correct community string.

All net-snmp users should upgrade to these updated packages, which contain
a backported patch to correct this issue. After installing the update, the
snmpd and snmptrapd daemons will be restarted automatically.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0295.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0295";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.0.9~2.30E.27", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-debuginfo", rpm:"net-snmp-debuginfo~5.0.9~2.30E.27", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.0.9~2.30E.27", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-libs", rpm:"net-snmp-libs~5.0.9~2.30E.27", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-perl", rpm:"net-snmp-perl~5.0.9~2.30E.27", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-utils", rpm:"net-snmp-utils~5.0.9~2.30E.27", rls:"RHENT_3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
