//                                               -*- C++ -*-
/**
 *  @file  t_SQP_std.cxx
 *  @brief The test file of class SQP for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_SQP_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "Exception.hxx"
#include "SQP.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    try {
      // Test function operator ()
      NumericalMathFunction levelFunction("TestOptimLinear");
      SQPSpecificParameters specific;


      NumericalPoint startingPoint(4, 1.0);
      SQP mySQPAlgorithm(specific, levelFunction);
      mySQPAlgorithm.setStartingPoint(startingPoint);
      mySQPAlgorithm.setLevelValue(3.0);
      mySQPAlgorithm.setMaximumIterationsNumber(100);
      mySQPAlgorithm.setMaximumAbsoluteError(1.0e-10);
      mySQPAlgorithm.setMaximumRelativeError(1.0e-10);
      mySQPAlgorithm.setMaximumResidualError(1.0e-10);
      mySQPAlgorithm.setMaximumConstraintError(1.0e-10);
      fullprint << "mySQPAlgorithm=" << mySQPAlgorithm << std::endl;

      Study myStudy;
      myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
      myStudy.add("mySQPAlgorithm", mySQPAlgorithm);
      myStudy.save();

      Study myStudy2;
      myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
      myStudy2.load();
      SQP sqp;
      myStudy2.fillObject("mySQPAlgorithm", sqp);
      fullprint << "loaded SQP=" << sqp << std::endl;

    }
    catch (NoWrapperFileFoundException & ex) {
      throw TestFailed(ex.__repr__());
    }


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
