//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalDistributionHessian.cxx
 *  @brief Class for the InverseNataf transformation hessian for elliptical
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: InverseNatafEllipticalDistributionHessian.cxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#include "OTprivate.hxx"
#include "InverseNatafEllipticalDistributionHessian.hxx"
#include "SymmetricTensor.hxx"
#include "PersistentObjectFactory.hxx"

BEGIN_NAMESPACE_OPENTURNS

/*
 * @class InverseNatafEllipticalDistributionHessian
 *
 * This class offers an interface for the InverseNataf function for elliptical distributions
 */

CLASSNAMEINIT(InverseNatafEllipticalDistributionHessian);

static Factory<InverseNatafEllipticalDistributionHessian> RegisteredFactory("InverseNatafEllipticalDistributionHessian");

/* Default constructor */
InverseNatafEllipticalDistributionHessian::InverseNatafEllipticalDistributionHessian():
  ConstantNumericalMathHessianImplementation()
{
  // Nothing to do
}

/* Parameter constructor */
InverseNatafEllipticalDistributionHessian::InverseNatafEllipticalDistributionHessian(const UnsignedLong dimension):
  ConstantNumericalMathHessianImplementation(SymmetricTensor(dimension, dimension))
{
  // Nothing to do
}

/* String converter */
String InverseNatafEllipticalDistributionHessian::__repr__() const
{
  return OSS() << "class=" << InverseNatafEllipticalDistributionHessian::GetClassName();
}

/* Method save() stores the object through the StorageManager */
void InverseNatafEllipticalDistributionHessian::save(Advocate & adv) const
{
  ConstantNumericalMathHessianImplementation::save(adv);
}

/* Method load() reloads the object from the StorageManager */
void InverseNatafEllipticalDistributionHessian::load(Advocate & adv)
{
  ConstantNumericalMathHessianImplementation::load(adv);
}

END_NAMESPACE_OPENTURNS
