//                                               -*- C++ -*-
/**
 *  @file  Composite.hxx
 *  @brief Composite experiment plane
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: Composite.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_COMPOSITE_HXX
#define OPENTURNS_COMPOSITE_HXX

#include "StratifiedExperiment.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class Composite
 *
 * The class describes the probabilistic concept of composite experiment plan
 */
class Composite
  : public StratifiedExperiment
{
  CLASSNAME;
public:


  /** Default constructor */
  explicit Composite(const String & name = DefaultName);

  /** Constructor with parameters */
  explicit Composite(const NumericalPoint & center,
                     const NumericalPoint & levels,
                     const String & name = DefaultName);

  /** Constructor with parameters */
  explicit Composite(const UnsignedLong dimension,
                     const NumericalPoint & levels,
                     const String & name = DefaultName);

  /** Virtual constructor */
  virtual Composite * clone() const;

  /** Experiment plane generation */
  virtual NumericalSample generate();

  /** String converter */
  virtual String __repr__() const;

}; /* class Composite */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_COMPOSITE_HXX */
