//                                               -*- C++ -*-
/**
 *  @file  HistoryStrategy.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: HistoryStrategy.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "HistoryStrategy.hxx"
#include "Null.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class HistoryStrategy
 */

CLASSNAMEINIT(HistoryStrategy);

/* Defaultonstructor */
HistoryStrategy::HistoryStrategy()
  : TypedInterfaceObject<HistoryStrategyImplementation>(Null().clone())
{
  // Nothing to do
}

/* Constructor with parameters */
HistoryStrategy::HistoryStrategy(Implementation & p_implementation)
  : TypedInterfaceObject<HistoryStrategyImplementation>(p_implementation)
{
  // Nothing to do
}

/* Constructor with parameters */
HistoryStrategy::HistoryStrategy(const HistoryStrategyImplementation & implementation)
  : TypedInterfaceObject<HistoryStrategyImplementation>(implementation.clone())
{
  // Nothing to do
}

/* Store the point according to the strategy */
void HistoryStrategy::store(const NumericalPoint & point)
{
  copyOnWrite();
  getImplementation()->store(point);
}

void HistoryStrategy::store(const NumericalSample & sample)
{
  copyOnWrite();
  getImplementation()->store(sample);
}

/* Reset the history storage through the isInitialized_ flag */
void HistoryStrategy::reset()
{
  getImplementation()->reset();
}

/* History sample accessor */
NumericalSample HistoryStrategy::getSample() const
{
  return getImplementation()->getSample();
}

/* String converter */
String HistoryStrategy::__repr__() const
{
  OSS oss;
  oss << "class=" << HistoryStrategy::GetClassName()
      << " implementation=" << getImplementation()->__repr__();
  return oss;
}



END_NAMESPACE_OPENTURNS
