//                                               -*- C++ -*-
/**
 *  @file  HaselgroveSequence.hxx
 *  @brief Implementation of the Haselgrove sequence
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */

#ifndef OPENTURNS_HASELGROVESEQUENCE_HXX
#define OPENTURNS_HASELGROVESEQUENCE_HXX

#include "LowDiscrepancySequenceImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS
/**
 * @class HaselgroveSequence
 */

class HaselgroveSequence :
  public LowDiscrepancySequenceImplementation
{
  CLASSNAME;

public:

  /** Constructor with parameters */
  explicit HaselgroveSequence(const UnsignedLong dimension = 1);

  /** Constructor with parameters */
  explicit HaselgroveSequence(const NumericalPoint & base);

  /** Virtual constructor */
  virtual HaselgroveSequence * clone() const;

  /** Initialize the sequence */
  void initialize(const UnsignedLong dimension);

  /** Generate a quasi-random vector of numbers uniformly distributed over [0, 1[ */
  using LowDiscrepancySequenceImplementation::generate;
  NumericalPoint generate();

  /** String converter */
  String __repr__() const;
  String __str__(const String & offset = "") const;

private:

  /** Base for the generation of the sequence */
  NumericalPoint base_;

  /** Current seed into the sequence */
  uint64_t seed_;

}; /* class HaselgroveSequence */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_HASELGROVESEQUENCE_HXX */
