//                                               -*- C++ -*-
/**
 *  @file  NearestPointCheckerResult.hxx
 *  @brief NearestPointCheckerResult stores the test result
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: NearestPointCheckerResult.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_NEARESTPOINTCHECKERRESULT_HXX
#define OPENTURNS_NEARESTPOINTCHECKERRESULT_HXX

#include "OTprivate.hxx"
#include "NumericalSample.hxx"
#include "PersistentObject.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class NearestPointCheckerResult
 * NearestPointCheckerResult stores the test result
 */
class NearestPointCheckerResult:
  public PersistentObject
{
  CLASSNAME;
public:

  /** Default constructor */
  NearestPointCheckerResult();

  /** Standard constructor */
  NearestPointCheckerResult(const NumericalSample & verifyingConstraintPoints,
                            const NumericalSample & verifyingConstraintValues,
                            const NumericalSample & violatingConstraintPoints,
                            const NumericalSample & violatingConstraintValues);


  /** Virtual constructor */
  virtual NearestPointCheckerResult * clone() const;

  /** Assigment operator */

  /** verifyingConstraintPoints accessor */
  NumericalSample  getVerifyingConstraintPoints() const;
  /** verifyingConstraintValues accessor */
  NumericalSample  getVerifyingConstraintValues() const;
  /** violatingConstraintPoints accessor */
  NumericalSample  getViolatingConstraintPoints() const;
  /** violatingConstraintValues accessor */
  NumericalSample  getViolatingConstraintValues() const;
  /** verifyingConstraintPoints accessor */
  void setVerifyingConstraintPoints(const NumericalSample & verifyingConstraintPoints);

  /** verifyingConstraintValues accessor */
  void setVerifyingConstraintValues(const NumericalSample & verifyingConstraintValues);

  /** violatingConstraintPoints accessor */
  void setViolatingConstraintPoints(const NumericalSample & violatingConstraintPoints);

  /** violatingConstraintValuess accessor */
  void setViolatingConstraintValues(const NumericalSample & violatingConstraintValues);

  /** String converter */
  String __repr__() const;

private:


  NumericalSample verifyingConstraintPoints_;
  NumericalSample verifyingConstraintValues_;
  NumericalSample violatingConstraintPoints_;
  NumericalSample violatingConstraintValues_;

}; // class NearestPointCheckerResult

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_NEARESTPOINTCHECKER_HXX */
