//                                               -*- C++ -*-
/**
 *  @file  BoxCoxTransform.hxx
 *  @brief Abstract top-level class for all numerical math function implementations
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: BoxCoxTransform.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_BOXCOXTRANSFORM_HXX
#define OPENTURNS_BOXCOXTRANSFORM_HXX

#include "SpatialFunction.hxx"
#include "NumericalPoint.hxx"
#include "Collection.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class BoxCoxTransform
 *
 * The class that simulates the classical Box Cox method which acts on the spatial part of a time series.
 */

class InverseBoxCoxTransform;

class BoxCoxTransform
  : public SpatialFunction

{
  CLASSNAME;
public:




  /** Default constructor */
  BoxCoxTransform();

  /** Standard parameter constructor */
  BoxCoxTransform(const NumericalPoint & lambdaPoint);

  /** NumericalScalarCollection parameter constructor */
  BoxCoxTransform(const Collection<NumericalScalar> & lambdaCollection);

  /** 1D NumericalScalar parameter constructor */
  BoxCoxTransform(const NumericalScalar & lambdaScalar);

  /** Virtual constructor */
  BoxCoxTransform * clone() const;

  /** Comparison operator */
  Bool operator ==(const BoxCoxTransform & other) const;

  /** String converter */
  String __repr__() const;
  String __str__(const String & offset = "") const;

  /** Operator () */
  TimeSeries operator() (const TimeSeries & inTS) const;

  /** Lambda accessor */
  NumericalPoint getLambda () const;

  /** Evaluation accessor */
  EvaluationImplementation getEvaluation() const;

  /** Inverse accessor */
  InverseBoxCoxTransform getInverse() const;

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

private:

  /** Internal setDefaultDescription method */
  void setDefaultDescription();

  /** NumericalPoint lambda ==> get a copy is better than a dynamic_cast */
  NumericalPoint lambda_;

}; /* class BoxCoxTransform */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_BOXCOXTRANSFORM_HXX */
