//                                               -*- C++ -*-
/**
 *  @file  Os.hxx
 *  @brief This class provides operating system specific variables
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-12 14:29:13 +0100 (jeu. 12 févr. 2009) $
 *  Id:      $Id: Path.hxx 1132 2009-02-12 13:29:13Z dutka $
 */

#ifndef OPENTURNS_OS_HXX
#define OPENTURNS_OS_HXX

#include "OTtypes.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class Os
 *
 * This class provides operating system specific.
 */
class Os
{
  static Bool UseCreateProcess_;

public:

  /**
   * Return the path separator of the target OS.
   */
  static const char * GetDirectorySeparator();

  /**
   * Return the separator to split directory list.
   */
  static const char * GetDirectoryListSeparator();

  /**
   * Return the end of line in text files
   */
  static const char * GetEndOfLine();

  /**
   * Return the command that permit to snub the output of a command.
   */
  static String GetDeleteCommandOutput();

#ifdef WIN32
  // Management of the technology used for system calls under Windows
  static void EnableCreateProcess();
  static void DisableCreateProcess();
  static Bool IsCreateProcessEnabled();
#endif


  /**
   * Make a system call. Return 0 if no error.
   */
  static int ExecuteCommand(const String & command);

private:

  /** Default constructor */
  Os() {};

}; /* class Os */


END_NAMESPACE_OPENTURNS


#endif /* OPENTURNS_OS_HXX */


