#include <Python.h>
#include <dlfcn.h>
#include <string.h>
#include <malloc.h>
#include <OTconfig.h>

#ifndef LIBINSTALL_PATH
#error LIBINSTALL_PATH not defined. Check configuration.
#endif

#ifndef OPENTURNS_HOME_ENV_VAR
#error "OPENTURNS_HOME_ENV_VAR is NOT defined. Check configuration."
#endif

static PyMethodDef Openturns_PreloadMethods[] = {
  {NULL, NULL, 0, NULL}        /* Sentinel */
};

PyMODINIT_FUNC
initopenturns_preload(void)
{
  PyObject *m;
  void *handle;

  m = Py_InitModule( "openturns_preload", Openturns_PreloadMethods );
  if (m == NULL) {
    PyErr_SetString( PyExc_ImportError, "Initialization of module 'openturns_preload' failed" );
    return;
  }

#ifndef WIN32
#define LIB_OT_FILENAME "libOT.so.0"
#define LIB_OT_PATH "/lib/openturns/"
#else
#define LIB_OT_FILENAME "libOT-0.dll"
#define LIB_OT_PATH "/lib/bin/"
#endif
  dlerror();    /* Clear any existing error */

  // Try to open the library libOT.so.0. We look for it in the following directories:
  // 1. Standard paths (LD_LIBRARY_PATH, /lib, /usr/lib)
  // 2. ${OPENTURNS_HOME}/lib/openturns
  // 3. Installation directory
  const int dlopenFlag = RTLD_NOW | RTLD_GLOBAL;
  handle = dlopen ( LIB_OT_FILENAME, dlopenFlag );
  if (!handle) {
    const char * otHome = getenv(OPENTURNS_HOME_ENV_VAR);
    if (otHome) {
      const char suffix[] = LIB_OT_PATH  LIB_OT_FILENAME;
      char * path = (char *) calloc( strlen(otHome) + strlen(suffix) + 1, sizeof(char) );
      strcpy( path, otHome );
      strcat( path, suffix );
      handle = dlopen ( path, dlopenFlag );
      free( path );
    }
  }
  if (!handle) {
    handle = dlopen ( LIBINSTALL_PATH "/" LIB_OT_FILENAME, dlopenFlag );
  }
  if (!handle) {
    char * msg = strdup( dlerror() );
    const char prefix[] = "Dynamic loading of library '" LIB_OT_FILENAME "' failed (tried in standard paths, "
			  "${OPENTURNS_HOME}/lib/openturns, and installation path). Reason: ";
    char * buf = (char *) calloc( strlen(prefix) + strlen(msg) + 1, sizeof(char) );
    strcpy( buf, prefix );
    strcat( buf, msg );

    PyErr_SetString( PyExc_IOError, buf );

    free( buf );
    free( msg );
    return;
  }

  dlerror();    /* Clear any existing error */
}
