// SWIG file SVMRegression.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: SVMRegression.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "SVMRegression.hxx"
%}

%include SVMRegression.hxx

namespace OpenTURNS { namespace Uncertainty { namespace Algorithm {

	/**
	* @class SVMRegressionSpecificParameters
	*	parameters of the SVM for regression
	*/
class SVMRegressionSpecificParameters
	: public OpenTURNS::Base::Common::PersistentObject
{

	CLASSNAME;
public :
	/* Default constructor */
	SVMRegressionSpecificParameters();

	/* Parameters constructor */
	SVMRegressionSpecificParameters(const OpenTURNS::Uncertainty::Algorithm::SVMRegression::NumericalPoint & candidateC, const OpenTURNS::Uncertainty::Algorithm::SVMRegression::NumericalPoint & candidateKernelParameter);

	/* Copy constructor */
	SVMRegressionSpecificParameters(const SVMRegressionSpecificParameters & other);

	/* Virtual constructor */
	virtual SVMRegressionSpecificParameters * clone() const;

	/* Destructor */
	virtual ~SVMRegressionSpecificParameters();

	/* String converter */
	String __repr__() const;
	
	/* Epsilon parameter accessor */
	void setEpsilon(NumericalScalar epsilon);
	NumericalScalar getEpsilon() const;

	/* C parameter accessor */
	void setC(NumericalScalar c);
	NumericalScalar getC() const;

	/* Values used to adjust c parameter */
	void setCandidateC(const OpenTURNS::Uncertainty::Algorithm::SVMRegression::NumericalPoint candidateC);
	OpenTURNS::Uncertainty::Algorithm::SVMRegression::NumericalPoint getCandidateC() const;

	/* Kernel parameter accessor */
	void setKernelParameter(NumericalScalar kernelParameter);
	NumericalScalar getKernelParameter() const;

	/* Candidate kernel parameter accessor */
	void setCandidateKernelParameter(OpenTURNS::Uncertainty::Algorithm::SVMRegression::NumericalPoint candidateKernelParameter);
	OpenTURNS::Uncertainty::Algorithm::SVMRegression::NumericalPoint getCandidateKernelParameter() const;

	/* Number of folds accessor */
	void setNumberOfFold(UnsignedLong numberOfFold);
	UnsignedLong getNumberOfFold() const;

} ; // class SVMRegressionSpecificParameters

}}}
namespace OpenTURNS{ namespace Uncertainty { namespace Algorithm { %extend SVMRegression { SVMRegression(const SVMRegression & other) { return new OpenTURNS::Uncertainty::Algorithm::SVMRegression(other); } } }}}
