// SWIG file SQP.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
// Id : $Id: SQP.i 1262 2009-05-28 12:47:53Z dutka $

%{
#include "SQP.hxx"
%}

%include SQP.hxx

namespace OpenTURNS { namespace Base { namespace Optim {
/*
 * @class SQPSpecificParameters
 * Specific parameters of the cobyla library
 */
class SQPSpecificParameters: public
  OpenTURNS::Base::Common::PersistentObject
{
  /* Multiplicative decrease of linear step */
  static const NumericalScalar DEFAULT_TAU;
  /* Armijo factor */
  static const NumericalScalar DEFAULT_OMEGA;
  /* Growing factor in penalization term */
  static const NumericalScalar DEFAULT_SMOOTH;

  CLASSNAME;
public:
  /* Default constructor */
  SQPSpecificParameters();

  /* Parameters constructor */
  SQPSpecificParameters(const NumericalScalar tau, const NumericalScalar omega, const NumericalScalar smooth);

  /* Copy constructor */
  SQPSpecificParameters(const SQPSpecificParameters & other);

  /* Virtual constructor */
  virtual SQPSpecificParameters * clone() const;

  /* Destructor */
  virtual ~SQPSpecificParameters();

  /* Tau accessor */
  NumericalScalar getTau() const;

  /* Tau accessor */
  void setTau(const NumericalScalar tau);

  /* Omega accessor */
  NumericalScalar getOmega() const;

  /* Omega accessor */
  void setOmega(const NumericalScalar tau);

  /* Smooth accessor */
  NumericalScalar getSmooth() const;

  /* Smooth accessor */
  void setSmooth(const NumericalScalar tau);

  /* String converter */
  String __repr__() const;

}; /* class SQPSpecificParameters */

}}}
namespace OpenTURNS{ namespace Base { namespace Optim { %extend SQP { SQP(const SQP & other) { return new OpenTURNS::Base::Optim::SQP(other); } } }}}
