// SWIG file OTtypes.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2010-02-01 17:40:34 +0100 (lun. 01 févr. 2010) $
// Id : $Id: OTtypes.i 1462 2010-02-01 16:40:34Z dutka $

%module types

%include std_string.i
%include std_map.i
%include std_complex.i

%include OT.hxx
%include OTtypes.hxx

%{
#include "OT.hxx"
#include "PythonWrappingFunctions.hxx"


namespace OpenTURNS { 



  template <>
  struct traitsPythonType<OpenTURNS::Base::Type::NumericalPoint>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Type::NumericalPoint
  convert<_PySequence_,OpenTURNS::Base::Type::NumericalPoint>(PyObject * pyObj)
  {
    OpenTURNS::Base::Common::Pointer<OpenTURNS::Base::Type::Collection<OpenTURNS::NumericalScalar> > ptr = buildCollectionFromPySequence<OpenTURNS::NumericalScalar>( pyObj );
    return OpenTURNS::Base::Type::NumericalPoint( *ptr );
  }



  template <>
  struct traitsPythonType<OpenTURNS::Base::Type::Indices>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Type::Indices
  convert<_PySequence_,OpenTURNS::Base::Type::Indices>(PyObject * pyObj)
  {
    OpenTURNS::Base::Common::Pointer<OpenTURNS::Base::Type::Collection<OpenTURNS::UnsignedLong> > ptr = buildCollectionFromPySequence<OpenTURNS::UnsignedLong>( pyObj );
    return OpenTURNS::Base::Type::Indices( ptr->begin(), ptr->end() );
  }




  template <>
  struct traitsPythonType<OpenTURNS::Base::Func::WrapperDataFile>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Func::WrapperDataFile
  convert<_PySequence_,OpenTURNS::Base::Func::WrapperDataFile>(PyObject * pyObj)
  {
    return OpenTURNS::Base::Func::WrapperDataFile();
  }



  template <>
  struct traitsPythonType<OpenTURNS::Base::Func::WrapperDataVariable>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Func::WrapperDataVariable
  convert<_PySequence_,OpenTURNS::Base::Func::WrapperDataVariable>(PyObject * pyObj)
  {
    return OpenTURNS::Base::Func::WrapperDataVariable();
  }


} /* namespace OpenTURNS */

%}

typedef OpenTURNS::FileName          FileName;
typedef OpenTURNS::String            String;
typedef OpenTURNS::Bool              Bool;
typedef OpenTURNS::NumericalScalar   NumericalScalar;
typedef OpenTURNS::NumericalComplex  NumericalComplex;
typedef OpenTURNS::Id                Id;
typedef OpenTURNS::PointInSourceFile PointInSourceFile;

%typemap(in) NumericalScalar {
  $1 = PyFloat_AsDouble($input);
}

%typemap(in) NumericalComplex {
  $1 = Complex(PyFloat_AsDouble($input.real()), PyFloat_AsDouble($input.imag()));
}

%typemap(out) NumericalComplex {
    $result = complex(PyFloat_FromDouble($1.real()), PyFloat_FromDouble($1.imag()));
}



%ignore *::save(StorageManager::Advocate & adv);
%ignore *::load(StorageManager::Advocate & adv);
