// SWIG file NumericalPointWithDescription.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: NumericalPointWithDescription.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "NumericalPointWithDescription.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Type::NumericalPointWithDescription>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Type::NumericalPointWithDescription
  convert<_PySequence_,OpenTURNS::Base::Type::NumericalPointWithDescription>(PyObject * pyObj)
  {
    check<_PySequence_>( pyObj );

    const OpenTURNS::UnsignedLong size = PySequence_Fast_GET_SIZE( pyObj );
    OpenTURNS::Base::Type::NumericalPointWithDescription * p_np = new OpenTURNS::Base::Type::NumericalPointWithDescription( size );
    OpenTURNS::Base::Type::Description desc = OpenTURNS::Base::Type::Description( size );

    for(OpenTURNS::UnsignedLong i=0; i<size; ++i) {
      PyObject * elt = PySequence_Fast_GET_ITEM( pyObj, i );
      check<_PySequence_>( elt );
      if (PySequence_Fast_GET_SIZE( elt ) == 2) {
        PyObject * item_0 = PySequence_Fast_GET_ITEM( elt, 0 );
        check<_PyString_>( item_0 );
        desc[i] = convert<_PyString_,OpenTURNS::String>( item_0 );
        PyObject * item_1 = PySequence_Fast_GET_ITEM( elt, 1 );
        check<_PyFloat_>( item_1 );
        (*p_np)[i] = convert<_PyFloat_,OpenTURNS::NumericalScalar>( item_1 );
      } else throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Sequence item " << i << " passed as argument is not a pair (String, NumericalScalar)";
    }

    p_np->setDescription( desc );
    return *p_np;
  }


} /* namespace OpenTURNS */

%}

%rename(NumericalPointWithDescription_operator___eq__) OpenTURNS::Base::Type::operator ==(const NumericalPointWithDescription & lhs, const NumericalPointWithDescription & rhs);

%include NumericalPointWithDescription.hxx
namespace OpenTURNS{ namespace Base { namespace Type {

%extend NumericalPointWithDescription {

NumericalPointWithDescription(const NumericalPointWithDescription & other)
{
  return new OpenTURNS::Base::Type::NumericalPointWithDescription(other);
}


NumericalPointWithDescription(PyObject * pyObj)
{
  return new OpenTURNS::Base::Type::NumericalPointWithDescription( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Type::NumericalPointWithDescription>(pyObj) );
}

}
}}}

%template(NumericalPointWithDescriptionCollection)                                    OpenTURNS::Base::Type::Collection<OpenTURNS::Base::Type::NumericalPointWithDescription>;
%template(NumericalPointWithDescriptionPersistentCollection)                          OpenTURNS::Base::Type::PersistentCollection<OpenTURNS::Base::Type::NumericalPointWithDescription>;
