// SWIG file CorrelationAnalysis.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
// Id : $Id: CorrelationAnalysis.i 1262 2009-05-28 12:47:53Z dutka $

%{
#include "CorrelationAnalysis.hxx"
%}

%include CorrelationAnalysis.hxx

namespace OpenTURNS { namespace Base { namespace Stat {

/**
	* @class SobolIndiceParameters
	*	Used to select which indices to compute
	*/
class CorrelationAnalysisSobolIndiceParameters
	: public OpenTURNS::Base::Common::PersistentObject
{
	static const UnsignedLong DefaultMaximumOrder = 0;
	static const Bool DefaultTotalIndiceComputation = false;

	CLASSNAME;
public :
	/** default constructor */
	CorrelationAnalysisSobolIndiceParameters();

	/** destructor */
	virtual ~CorrelationAnalysisSobolIndiceParameters();

	/** Parameters constructor */
	CorrelationAnalysisSobolIndiceParameters(const UnsignedLong maximumOrder, const Bool computeTotalIndice);

	/** Virtual constructor */
	virtual CorrelationAnalysisSobolIndiceParameters * clone() const;

	/** Maximum Order accessor */
	UnsignedLong getMaximumOrder(void) const;
	void setMaximumOrder(UnsignedLong maximumOrder);

	/** Total Indice accessor */
	Bool getTotalIndiceComputation(void) const;
	void setTotalIndiceComputation(Bool totalIndiceComputation);

	/** String converter */
	String __repr__() const;

}; // class CorrelationAnalysisSobolIndiceParameters

}}}

namespace OpenTURNS { namespace Base { namespace Stat {

	/**
	* @class SobolIndiceResult
	*	Stores every Sobol' indices
	*/
class CorrelationAnalysisSobolIndiceResult
	: public OpenTURNS::Base::Common::PersistentObject
{
	CLASSNAME;

public :
	/** default constructor */
	CorrelationAnalysisSobolIndiceResult();

	/** destructor */
	virtual ~CorrelationAnalysisSobolIndiceResult();

	/** Virtual constructor */
	virtual CorrelationAnalysisSobolIndiceResult * clone() const;

	/** first order Sobol' indices accessor */
	Base::Type::NumericalPoint getFirstOrderIndice() const;
	void setFirstOrderIndice(Base::Type::NumericalPoint firstOrderIndice);

	/** second order Sobol' indices accessor */
	Base::Type::SymmetricMatrix getSecondOrderIndice() const;
	void setSecondOrderIndice(const Base::Type::SymmetricMatrix secondOrderIndice);

	/** third order Sobol' indices accessor */
	Base::Type::SymmetricTensor getThirdOrderIndice() const;
	void setThirdOrderIndice(const Base::Type::SymmetricTensor thirdOrderIndice);

	/** total order (order = dimension - 1) Sobol' indices accessor */
	Base::Type::NumericalPoint getTotalOrderIndice() const;
	void setTotalOrderIndice(const Base::Type::NumericalPoint totalOrderIndice);

	/** String converter */
	String __repr__() const;

}; // class CorrelationAnalysisSobolIndiceResult

}}}

namespace OpenTURNS { namespace Base { namespace Stat { %extend CorrelationAnalysis { CorrelationAnalysis(const CorrelationAnalysis & other) { return new OpenTURNS::Base::Stat::CorrelationAnalysis(other); } } }}}
