//                                               -*- C++ -*-
/**
 * @file  t_MethodBoundNumericalMathEvaluationImplementation_std.cxx
 * @brief The test file of class MethodBoundNumericalMathEvaluationImplementation for standard methods
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2008-07-03 08:31:34 +0200 (jeu, 03 jui 2008) $
 *  Id:      $Id: t_MethodBoundNumericalMathEvaluationImplementation_std.cxx 867 2008-07-03 06:31:34Z lebrun $
 */

#include <iostream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "MethodBoundNumericalMathEvaluationImplementation.hxx"
#include "NumericalMathFunction.hxx"
#include "Exception.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    Normal distribution(0, 1.0);
    NumericalMathFunction function = bindMethod <Normal, NumericalScalar, NumericalScalar> ( distribution, &Normal::computeDDF, 1, 1 );
    NumericalPoint p(1, 1.0);
    fullprint << "Normal DDF=" << distribution.computeDDF(p) << std::endl;
    fullprint << "bind DDF  =" << function(p)[0] << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
