//                                               -*- C++ -*-
/**
 *  @file  t_LinearTaylor_std.cxx
 *  @brief The test file of class LinearTaylor for standard methods
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: t_LinearTaylor_std.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "LinearTaylor.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Uncertainty::Algorithm;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    NumericalScalar eps(0.2);
    /** Instance creation */
    NumericalMathFunction myFunc("TestResponseSurface");
    NumericalPoint center(myFunc.getInputDimension());
    for(UnsignedLong i = 0; i < center.getDimension(); i++)
      {
	center[i] = 1.0+i;
      }
    LinearTaylor myTaylor(center, myFunc);
    myTaylor.run();
    NumericalMathFunction responseSurface(myTaylor.getResponseSurface());
    fullprint << "myTaylor=" << myTaylor << std::endl;
    fullprint << "responseSurface=" << responseSurface << std::endl;
    fullprint << "myFunc(" << center << ")=" << myFunc(center) << std::endl;
    fullprint << "responseSurface(" << center << ")=" << responseSurface(center) << std::endl;
    NumericalPoint in(center);
    in[0] += eps;
    in[1] -= eps/2;
    fullprint << "myFunc(" << in << ")=" << myFunc(in) << std::endl;
    fullprint << "responseSurface(" << in << ")=" << responseSurface(in) << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
