//                                               -*- C++ -*-
/**
 *  @file  Compact.hxx
 *  @brief This class is a top-level class for the history mechanism of
 *  simulation algorithms. It delegates to its children the effective
 *  history strategy.
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $CompactChangedBy$
 *  @date:   $CompactChangedDate$
 *  Id:      $Id: Compact.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_COMPACT_HXX
#define OPENTURNS_COMPACT_HXX

#include "HistoryStrategyImplementation.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS
{

  namespace Base 
  {

    namespace Stat
    {

      /**
       * @class Compact
       */

      class Compact
	: public HistoryStrategyImplementation
      {

	CLASSNAME;

      public:

	static const UnsignedLong DefaultHalfMaximumSize;

	typedef HistoryStrategyImplementation::NumericalPoint NumericalPoint;

	/** Constructor with parameters */
	explicit Compact();

	/** Constructor with parameters */
	Compact(const UnsignedLong halfMaximumSize);

	/** Virtual constructor */
	virtual Compact * clone() const;

	/** Store the point according to the strategy */
	void store(const NumericalPoint & point);

	/** Sample accessor */
	NumericalSample getSample() const;

	/** HalfMaximumSize accessor */
	UnsignedLong getHalfMaximumSize() const;

	/** Index accessor */
	UnsignedLong getIndex() const;

	/** String converter */
	String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);
      protected:

      private:
	// Maximum number of points to be hitorized
	UnsignedLong halfMaximumSize_;

	// Index where the next point will be stored
	UnsignedLong index_;;

	// Storage step
	UnsignedLong step_;

	// Throwing counter
	UnsignedLong throwingCounter_;

      } ; /* class Compact */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPACT_HXX */
